#include "stdio.h"
#include "math.h"
#include "rpn.c"
#include "string.h"
#define SSIZE 100 

float fsize;
float dx;

struct point {
	float x;
	float y;
};

struct pixel {
	int x;
	int y;
};

float max(float a, float b) {
	if(a > b) {
		return a;
	} else return b;
}

float min(float a, float b) {
	if(a < b) {
		return a;
	} else return b;
}

int in_bounds(int y) {
	if(y>SSIZE || y < 0) {
		return SSIZE/2;
	}
	else return y;	
}

struct point stoc(struct pixel screen) {
	float scale = fsize / (SSIZE / 2);
	struct point result = {(screen.x-SSIZE/2)*scale,(SSIZE/2-screen.y)*scale};
	return result;
}

struct pixel ctos(struct point coord) {
	int x = round(coord.x+SSIZE/2);
	int y = in_bounds(round(SSIZE/2-coord.y));
	struct pixel result = {x,y};
	return result;
}

void init_screen(int screen[SSIZE][SSIZE]) {
	for(int h=0;h<SSIZE;h++) {
		for(int w=0;w<SSIZE;w++) {
			struct pixel pixel = {w,h};
			if(stoc(pixel).x == 0 || stoc(pixel).y == 0) {
				screen[h][w] = 1;
			} else screen[h][w] = 0;
		}
	}
}

float expression(float x, char formula[], size_t formula_size) {

	int result = rpn(formula, formula_size, x);
	return result;
}

void draw_formula(int screen[SSIZE][SSIZE], char formula[], size_t formula_size) {
	struct pixel min = {0,0};
	struct pixel max = {SSIZE,SSIZE};
	for(float x=stoc(min).x;x<stoc(max).x;x+=dx) {
		struct point line = {x,0};
		line.y = expression(line.x, formula, formula_size);
		screen[ctos(line).y][ctos(line).x]=1;
	}
}



void print_screen(int screen[SSIZE][SSIZE]) {
	for(int h=0;h<SSIZE;h++) {
		for(int w=0;w<SSIZE;w++) {
			if(screen[h][w] == 1) {
				printf("#");
			} else printf(" ");
		}
		printf("\n");
	}
}

void draw_image(int screen[SSIZE][SSIZE]) {
	FILE* ptr = fopen("img.pgm","w");
	fprintf(ptr,"P2\n%d %d\n1\n",SSIZE,SSIZE);
	for(int h = 0; h < SSIZE; h++) {
		for(int w = 0; w < SSIZE; w++) {
			fprintf(ptr,"%d ",screen[h][w]);
		}
	}
	fclose(ptr);
}

int main(int argc, char *argv[]) {
	fsize = 100;
	switch(argc) {
		case 1:
			printf("Please enter at least 1 argument.\n");
			return 0;
			
		case 2:
			break;
		
		case 3:
			fsize = atoi(argv[1]);
			printf("%d\n",fsize);
			break;
		
	}
	dx = fsize / SSIZE;
	printf("%f\n",dx);
	int screen[SSIZE][SSIZE];
	init_screen(screen);
	draw_formula(screen,argv[argc-1],strlen(argv[argc-1]));
	draw_image(screen);
	return 0;
}
